% JTSP DOCUMENT CLASS
% v4
%
% LaTeX document class for JTSP Journal Entries
%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{jtsp1}[2023/02/14 JTSP LaTeX Class v4]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions

\PassOptionsToPackage{hidelinks}{hyperref}

\LoadClass[a4paper,twocolumn,10pt]{article}

\RequirePackage[default,scale=0.9]{opensans}
\RequirePackage[T1]{fontenc}
\RequirePackage[left=2.5cm,right=2.5cm,top=2.5cm,bottom=3cm,footskip=1cm]{geometry}
\RequirePackage{xcolor}
\RequirePackage{titlesec}
\RequirePackage{caption}
\RequirePackage{hyperref}
\RequirePackage{authblk}
\RequirePackage{fancyhdr}
\RequirePackage{graphicx}
\RequirePackage[switch]{lineno}

\renewcommand*{\Affilfont}{\normalsize\normalfont}
\renewcommand*{\Authfont}{\bfseries}

\pagestyle{fancy}
\fancyhf{}
\lhead{
	\@ifundefined{@authorsShort}
		{%
			% \@authorsShort not defined
		}
		{%
			\@authorsShort
		}%
}
\rhead{\@journalShort, \textbf{\@volume}, \@issue~(\@issueYear)}
\lfoot{ \textbf{\@volume}, \@issue}
\cfoot{\thepage}
\rfoot{\textcopyright G-Labs \the\year}
\renewcommand\headrule{}

\fancypagestyle{firstpagehead}{

	\renewcommand\headrule{%
		\begingroup
		\color{jtspgreen}
		\hrule height 1pt width\headwidth
		\endgroup
	}

	\lhead{\includegraphics[height=8.7mm]{glabslogo}}
	\rhead{\@journal, \textbf{\@volume}, \@issue~(\@issueYear)}
	\lfoot{ \textbf{\@volume}, \@issue}
	\cfoot{\thepage}
	\rfoot{\textcopyright~G-Labs \the\year}
}

\setcounter{Maxaffil}{1}

\def\equationautorefname~#1\null{%
  Equ.~(#1)\null
}
\def\figureautorefname~#1\null{%
  Fig.~(#1)\null
}
\def\tableautorefname~#1\null{%
  Tab.~(#1)\null
}

\captionsetup{justification=justified,font=small,format=hang,singlelinecheck=false,labelfont=bf}		
\setlength\parindent{0pt}

\def\arraystretch{1.5}

\setlength{\columnsep}{1cm}
\setlength{\doublerulesep}{2\arrayrulewidth}
\setlength{\headheight}{30pt}

\newcommand{\tableheading}[1]{\multicolumn{1}{|c}{\textbf{#1}}}
\newcommand{\tableheadinglast}[1]{\multicolumn{1}{|c|}{\textbf{#1}}  \\ \hline\hline}

\newcommand{\recvDate}[1]{\gdef\@recvDate{#1}}
\newcommand{\acceptedDate}[1]{\gdef\@acceptedDate{#1}}
\newcommand{\publDate}[1]{\gdef\@publDate{#1}}
\newcommand{\doi}[1]{\gdef\@doi{#1}}
\newcommand{\email}[1]{\gdef\@email{#1}}
\newcommand{\authorsShort}[1]{\gdef\@authorsShort{#1}}

\newcommand{\journal}[1]{\gdef\@journal{#1}}
\newcommand{\journalShort}[1]{\gdef\@journalShort{#1}}
\newcommand{\volume}[1]{\gdef\@volume{#1}}
\newcommand{\issue}[1]{\gdef\@issue{#1}}
\newcommand{\issueYear}[1]{\gdef\@issueYear{#1}}

\renewcommand\thesection{\Roman{section}.}
\renewcommand\thesubsection{\thesection\alph{subsection})}

\journal{Journal of Technological and Space Plasmas}
\journalShort{J. Technol. Space Plasmas}
\volume{Volume}
\issue{Issue}
\issueYear{Year}

\definecolor{jtspgreen}{RGB}{0,178,80}

\newcommand{\intro}[1]{
	\thispagestyle{firstpagehead}
	\twocolumn[
		\begin{@twocolumnfalse}
			
			\maketitle

            \begin{flushleft}
            (Received: \@recvDate, Accepted: \@acceptedDate, Published online: \@publDate)
            \end{flushleft}
   
			#1
			
			\vspace{1em}
			
			\@doi
			
			\vspace{2em}
			
			\@email
			
			\vspace{2em}
			\end{@twocolumnfalse}
	]

}

\makeatletter
\renewcommand{\maketitle}{\bgroup\setlength{\parindent}{0pt}
\begin{flushleft}
	\textcolor{jtspgreen}{{\LARGE\textbf{\@title}}}

  \@author
\end{flushleft}\egroup
}
\makeatother


\titleformat{\section}
  {\normalfont\Large\bfseries}
  {\hspace{6mm}\makebox[12mm][l]{\thesection}}
  {0pt}
  {}

\titleformat{\subsection}
  {\normalfont\bfseries}
  {\hspace{6mm}\makebox[12mm][l]{\thesubsection}}
  {0pt}
  {}
	
\AtEndDocument{
	\vspace{2em}
	\includegraphics[width=8mm]{cc}
	\includegraphics[width=8mm]{cc-by}
	
	\textbf{Open Access} 
	This article is licensed under a Creative Commons Attribution 4.0 International License, which permits use, sharing, adaptation, distribution and reproduction in any medium or format, as long as you give appropriate credit to the original author(s) and the source, provide a link to the Creative Commons license, and indicate if changes were made. The images or other third party material in this article are included in the articles Creative Commons license, unless indicated otherwise in a credit line to the material. If material is not included in the article's Creative Commons license and your intended use is not permitted by statutory regulation or exceeds the permitted use, you will need to obtain permission directly from the copyright holder. To view a copy of this license, visit: http://creativecommons.org/licenses/by/4.0/.
}